#!/system/bin/sh

# ---------------------
# Convenience Functions
# ---------------------
#
. ./func.inc.sh


# ----------------
# Variable defines
# ----------------
#
PATH=/system/bin:/system/xbin:$PATH

BinLoc=/system/bin
XBinLoc=/system/xbin

CacheLoc=/cache
DalvikLoc=/data/dalvik-cache

RmDirList="$CacheLoc $DalvikLoc"

BootImage=${BOOTIMG:-"zImage-MISSING"}
BootImageName=${BOOTIMGNAME:-"Unspecified zImage"}

BootPart=/dev/block/mmcblk0p5
RecoveryPart=/dev/block/mmcblk0p6

DDExe=/system/bin/dd
DDStatus1="$BootImage is missing"
DDStatus2="$BootImage is missing"

ImageExists=$(/system/bin/ls $BootImage 2> /dev/null)


# -------------
# Start Install
# -------------
#
echo -n "Installing BootImg - $BootImageName... "

for Conditional in $ImageExists ; do
  chmod 666 $BootPart
  DDStatus1=$($DDExe if=/dev/zero of=$BootPart bs=256 count=32765 2>&1)
  DDStatus1=$($DDExe if=$BootImage of=$BootPart bs=256 count=32765 2>&1)
  chmod 600 $BootPart

  chmod 666 $RecoveryPart
  DDStatus2=$($DDExe if=/dev/zero of=$RecoveryPart bs=256 count=32765 2>&1)
  DDStatus2=$($DDExe if=$BootImage of=$RecoveryPart bs=256 count=32765 2>&1)
  chmod 600 $RecoveryPart

  for DirName in $RmDirList ; do
    RM_RF $DirName
  done
done

echo "Done"

echo
echo ----
echo BootImg = $BootImage
echo
echo STATUS1 = $DDStatus1
echo
echo STATUS2 = $DDStatus2
echo ----
echo

# -------
# Sync FS
# -------
#
for Conditional in $ImageExists ; do
  echo -n "Waiting for filesystem to sync... "
  sync; sync; sync
  sleep 6
  echo "Done"
done
